using System;
using System.Collections.Generic;
using System.Collections.Concurrent;
using System.Threading.Tasks;

namespace LazarSpasic
{
    class Program
    {
        static int Abakus(int n)
        {
            HashSet<int> unikCifre = new HashSet<int>();
            int suma = 1;
            for(int i = 1; i <= n; i++)
            {
                int k = i;
                while(k > 0)
                {
                    suma *= k % 10;
                    k /= 10;
                }
                unikCifre.Add(suma);
                suma = 1;
            }

            return unikCifre.Count;
        }
        
        static void Main(string[] args)
        {
            int T = int.Parse(Console.ReadLine());

            var inp = new ConcurrentQueue<int>();
            var outp = new ConcurrentQueue<int>();

            var inpProc = new Task(() => {
                for(int i = 0; i < T; i++)
                {
                    inp.Enqueue(int.Parse(Console.ReadLine()));
                }
            });

            var Proc = new Task(() => { 
                while(!inp.IsEmpty && !inpProc.IsCompleted)
                {
                    inp.TryDequeue(out int num);
                    outp.Enqueue(Abakus(num));
                }
            });

            var outpProc = new Task(() => { 
                while(!outp.IsEmpty && !Proc.IsCompleted)
                {
                    outp.TryDequeue(out int res);
                    Console.WriteLine(res);
                }
            });
            Console.WriteLine(Abakus(int.Parse(Console.ReadLine())));
        }
    }
}